<?php
/**
 * Plugin Header Template
 *
 * Displays a consistent header across all Small Image admin pages
 *
 * @package Small_Image
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="relative bg-gradient-to-r from-white to-gray-50 border-b-4 border-blue-600 px-8 py-6 -mx-5 mb-8 shadow-lg overflow-hidden">
	<!-- Animated top border -->
	<div class="absolute top-0 left-0 right-0 h-1 bg-gradient-to-r from-blue-600 via-blue-800 to-blue-600 animate-pulse"></div>
	
	<div class="relative z-10 max-w-screen-xl mx-auto flex justify-between items-center flex-wrap gap-6">
		<!-- Left side: Branding -->
		<div class="flex items-center gap-5">
			<!-- Plugin icon with gradient and hover effect -->
			<div class="w-16 h-16 bg-gradient-to-br from-blue-600 to-blue-800 rounded-xl flex items-center justify-center shadow-xl hover:shadow-2xl hover:scale-105 transition-all duration-300 relative group overflow-hidden">
				<div class="absolute inset-0 bg-white opacity-20 rounded-full blur-xl animate-pulse"></div>
				<span class="dashicons dashicons-format-image text-white text-4xl relative z-10"></span>
			</div>
			
			<!-- Plugin info -->
			<div class="flex flex-col">
				<h1 class="text-3xl font-bold text-gray-900 leading-tight drop-shadow-sm"><?php esc_html_e( 'Small Image', 'small-image' ); ?></h1>
				<p class="text-sm text-gray-600 font-medium tracking-wide mt-1"><?php esc_html_e( 'Optimize Your Images with WebP', 'small-image' ); ?></p>
			</div>
		</div>
		
		<!-- Right side: Navigation -->
		<nav class="flex gap-3">
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=small-image' ) ); ?>" 
			   class="<?php echo ( isset( $_GET['page'] ) && $_GET['page'] === 'small-image' ) ? 'bg-gradient-to-r from-blue-600 to-blue-700 text-white shadow-lg shadow-blue-500/50' : 'bg-white text-gray-700 border-2 border-gray-200 hover:border-blue-500 hover:bg-gray-50'; ?> flex items-center gap-2 px-5 py-3 rounded-lg font-semibold text-sm transition-all duration-300 hover:-translate-y-1 hover:shadow-md relative overflow-hidden group">
				<span class="absolute inset-0 bg-gradient-to-r from-transparent via-white to-transparent opacity-0 group-hover:opacity-20 transition-opacity duration-500 -translate-x-full group-hover:translate-x-full"></span>
				<span class="dashicons dashicons-admin-home text-lg"></span>
				<span class="relative z-10"><?php esc_html_e( 'Dashboard', 'small-image' ); ?></span>
			</a>
			
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=small-image-bulk' ) ); ?>" 
			   class="<?php echo ( isset( $_GET['page'] ) && $_GET['page'] === 'small-image-bulk' ) ? 'bg-gradient-to-r from-blue-600 to-blue-700 text-white shadow-lg shadow-blue-500/50' : 'bg-white text-gray-700 border-2 border-gray-200 hover:border-blue-500 hover:bg-gray-50'; ?> flex items-center gap-2 px-5 py-3 rounded-lg font-semibold text-sm transition-all duration-300 hover:-translate-y-1 hover:shadow-md relative overflow-hidden group">
				<span class="absolute inset-0 bg-gradient-to-r from-transparent via-white to-transparent opacity-0 group-hover:opacity-20 transition-opacity duration-500 -translate-x-full group-hover:translate-x-full"></span>
				<span class="dashicons dashicons-images-alt2 text-lg"></span>
				<span class="relative z-10"><?php esc_html_e( 'Bulk Convert', 'small-image' ); ?></span>
			</a>
			
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=small-image-system-info' ) ); ?>" 
			   class="<?php echo ( isset( $_GET['page'] ) && $_GET['page'] === 'small-image-system-info' ) ? 'bg-gradient-to-r from-blue-600 to-blue-700 text-white shadow-lg shadow-blue-500/50' : 'bg-white text-gray-700 border-2 border-gray-200 hover:border-blue-500 hover:bg-gray-50'; ?> flex items-center gap-2 px-5 py-3 rounded-lg font-semibold text-sm transition-all duration-300 hover:-translate-y-1 hover:shadow-md relative overflow-hidden group">
				<span class="absolute inset-0 bg-gradient-to-r from-transparent via-white to-transparent opacity-0 group-hover:opacity-20 transition-opacity duration-500 -translate-x-full group-hover:translate-x-full"></span>
				<span class="dashicons dashicons-info text-lg"></span>
				<span class="relative z-10"><?php esc_html_e( 'System Info', 'small-image' ); ?></span>
			</a>
		</nav>
	</div>
</div>
